import { withQueryParams } from 'web-client/utilities/url-params';

export const FACEBOOK_SHARE_URL = 'https://www.facebook.com/sharer/sharer.php';
export const TWITTER_SHARE_URL = 'http://www.twitter.com/share';
export const REDDIT_SHARE_URL = 'http://www.reddit.com/submit';
const VK_SHARE_URL = 'http://vk.com/share.php';

export function facebookShareLink(url) {
  return withQueryParams(FACEBOOK_SHARE_URL, ['u'], { u: url });
}

export function twitterShareLink(url, text) {
  return withQueryParams(TWITTER_SHARE_URL, ['url', 'text'], { url, text });
}

export function redditShareLink(url, title) {
  return withQueryParams(REDDIT_SHARE_URL, ['url', 'title'], { url, title });
}

export function vkShareLink(url) {
  return withQueryParams(VK_SHARE_URL, ['url'], { url });
}
