

/*
 * Detect a version of Internet Explorer. Mostly taken from:
 *
 *   * http://stackoverflow.com/a/21712356
 *
 */
let _ieVersion;
export function getIEVersion() {
  if (_ieVersion === undefined) {
    _ieVersion = _getIEVersion();
  }
  return _ieVersion;
}

function _getIEVersion() {
  let ua = window.navigator.userAgent;

  let msie = ua.indexOf('MSIE ');
  if (msie > 0) {
    // IE 10 or older => return version number
    return parseInt(ua.substring(msie + 5, ua.indexOf('.', msie)), 10);
  }

  let trident = ua.indexOf('Trident/');
  if (trident > 0) {
    // IE 11 => return version number
    let rv = ua.indexOf('rv:');
    return parseInt(ua.substring(rv + 3, ua.indexOf('.', rv)), 10);
  }

  // other browser
  return null;
}

let _browserName;
export function getBrowserName() {
  // Opera 8.0+
  if ((window.hasOwnProperty('opr') && window.opr.hasOwnProperty('addons')) || window.hasOwnProperty('opera') || window.navigator.userAgent.indexOf(' OPR/') >= 0) {
    _browserName = 'opera';
  }
  // Firefox 1.0+
  else if (typeof window.InstallTrigger !== 'undefined') {
    _browserName = 'firefox';
  }
  // At least Safari 3+: "[object HTMLElementConstructor]"
  else if (Object.prototype.toString.call(window.HTMLElement).indexOf('Constructor') > 0) {
    _browserName = 'safari';
  }
  // Internet Explorer 6-11
  else if (/*@cc_on!@*/false || Boolean(document.documentMode)) {
    _browserName = 'ie';
  }
  // Edge 20+
  else if (window.hasOwnProperty('styleMedia')) {
    _browserName = 'edge';
  }
  // Chrome 1+
  else if (window.hasOwnProperty('chrome') && window.chrome.hasOwnProperty('webstore')) {
    _browserName = 'chrome';
  }
  return _browserName;
}
