import { assert } from 'ember-metal/utils';

export class StatsNode {

  constructor(label, value = 0, type = '') {
    this._label = label;
    this._value = value;
    this._type = type;
    this._nodes = {};
  }

  get label() {
    return this._label;
  }

  get value() {
    return this._value;
  }

  get type() {
    return this._type;
  }

  get nodes() {
    return this._nodes;
  }

  getChildNode(label) {
    return this._nodes[label];
  }

  setChildNode(node) {
    if (!node) {
      assert('Cannot set falsy child node value');
    }

    this._nodes[node.label] = node;
  }
}
