import { assert } from 'ember-metal/utils';
import { StatsNode } from 'web-client/utilities/video-stats/stats-node';

export class StatsPoint {

  constructor(timeStamp) {
    this._node = new StatsNode('', 0, 'root');
    this._timeStamp = timeStamp;
  }

  get timeStamp() {
    return this._timeStamp;
  }

  setChildNodeFor(selector, node) {
    if (!node) {
      assert(`Cannot set falsy node value for selector: '${selector}'`);
    }

    let parentNode = this.getNodeFor(selector);
    if (!parentNode) {
      assert(`No parentNode found when setting child for selector: '${selector}'`);
    }

    parentNode.setChildNode(node);
  }

  getNodeFor(selector) {
    if (!Array.isArray(selector)) {
      selector = [selector];
    }

    let selectedNode = this._node;
    if (selector.length === 0 || selector[0] === '') {
      return selectedNode;
    }

    for (let i = 0; i < selector.length; i++) {
      let nextSelector = selector[i];

      let nextNode = selectedNode.getChildNode(nextSelector);
      if(!nextNode) {
        return null;
      }

      selectedNode = nextNode;
    }

    return selectedNode;
  }
}
