export default class RetryTimer {
  constructor({ minInterval, maxInterval, backoff }) {
    this._minInterval = minInterval;
    this._maxInterval = maxInterval;
    this._backoff = backoff;
    this._retryCount = 0;
  }

  nextInterval() {
    let interval = Math.min(
      this._minInterval + (this._backoff * this._retryCount),
      this._maxInterval
    );
    this._retryCount++;

    return interval;
  }

  reset() {
    this._retryCount = 0;
  }
}

