/* globals i18n */
const DEFAULT = 'Untitled';

export default function(filename, options={}) {
  if (!filename) {
    return i18n(DEFAULT);
  }

  let dotParts = filename.split('.');

  if (dotParts.length > 1 && dotParts[0].length) {
    dotParts.pop();
  }

  let formattedTitle = dotParts
    .join(' ')
    .replace(/(_|-|\s)+/g, ' ')
    .trim()
    .slice(0, options.maxLength || Infinity);

  if (!formattedTitle.length) {
    return i18n(DEFAULT);
  }

  return formattedTitle;
}
