import RSVP from 'rsvp';

/**
 * The UploadScheduler enqueues files and uploads them one at a time.
 */
export default class UploadScheduler {
  constructor() {
    this.promise = RSVP.resolve();
  }

  /**
   * Enqueues a file upload. The returned promise will resolve when the file is
   * completely uploaded (retrying indefinietly). The returned promise rejects
   * if we encounter a server error that indicates the file is not valid and
   * should not be uploaded. However, chained promises will continue to be
   * processed.
   *
   * @param {FileTransfer} file - A FileTransfer object to upload
   * @return {Promise} A promise for the FileTransfer
   */
  push(fileTransfer) {
    this.promise = this.promise.finally(() => fileTransfer.send());

    return this.promise;
  }
}
