const GB = Math.pow(1024, 3);
export const GB_LIMIT = 20;
export const FILE_TYPES = ['.mp4','.mov','.flv','.avi'];
export const MIME_TYPES = ['video/mp4','video/quicktime','video/avi','video/x-flv','video/x-msvideo','video/*', ...FILE_TYPES];
export const FILE_SIZE_LIMIT = GB_LIMIT * GB;
export const FILE_SIZE_ERROR_MESSAGE = `Your file must be ${GB_LIMIT}GB or less`;
export const FILE_TYPE_ERROR_MESSAGE = 'Your file must be an mp4, mov, avi or flv';

/**
 * Determines if a file meets the server's upload requirements.
 *
 * @param {File|Blob} file - a video files to validate
 * @returns {String|null} an error message if the file is invalid or null if
 * the file is valid
 */
export default function validateVideoFile(file) {
  let errorMessage = null;

  if (file.size > FILE_SIZE_LIMIT) {
    errorMessage = FILE_SIZE_ERROR_MESSAGE;
  } else if ((file.type) && (MIME_TYPES.indexOf(file.type) === -1)) {
    errorMessage = FILE_TYPE_ERROR_MESSAGE;
  }

  return errorMessage;
}
