import { COLLECTION_ITEM_ID_DELIMITER } from 'web-client/serializers/video-playlist-item';
export const TYPE_VIDEO = 'video';

export function buildItemID(type, typeId) {
  return `${type}/${typeId}`;
}

export function extractIDMeta(itemId) {
  let [type, typeId] = itemId.split('/');
  return { type, id: typeId };
}

export function stripPlaylistId(id) {
  return id.split(COLLECTION_ITEM_ID_DELIMITER)[1];
}
