let libraries = {};

let configure = function(options) {
  libraries.display = options.display;
  libraries.notify = options.notify;

  if (!libraries.notify) {
    throw new Error("ember-vod-appeals should be configured with a reference " +
      "to the Twitch.notify object.");
  }

  if (!libraries.display) {
    libraries.display = {};
    libraries.display.lengthAsClock = function (seconds) {
      let hours = Math.floor(seconds/3600),
          minutes = Math.floor((seconds%3600)/60),
          out = [];

      seconds = seconds%60;

      if (hours) {
        out.push(hours);
      }
      out.push(minutes < 10 ? `0${minutes}` : minutes);
      out.push(seconds < 10 ? `0${seconds}` : seconds);

      return out.join(':');
    };
  }
};

let isHls = function (id) {
  return id && id[0] === 'v';
};

export {
  configure,
  libraries,
  isHls
};
