export const TIMEZONE_URL = 'https://vod-secure.twitch.tv/timezones.json';
import tz from 'moment-timezone';
import emberAjaxRequest from 'ember-ajax';
import RSVP from 'rsvp';

let isLoaded = false;
let pendingPromise = null;

export default function withMomentTimezoneData(request = emberAjaxRequest) {
  if (isLoaded) {
    return RSVP.resolve(tz);
  } else if (pendingPromise) {
    return pendingPromise;
  }

  pendingPromise = request(TIMEZONE_URL).then((data) => {
    tz.load(data);
    isLoaded = true;

    return tz;
  }).finally(() => {
    pendingPromise = null;
  });

  return pendingPromise;
}

export function reset() {
  isLoaded = false,
  pendingPromise = null;
}
