/* eslint-env node */
var ES6Modules = require('broccoli-es6modules');
var esTranspiler = require('broccoli-babel-transpiler');
var mergeTrees = require('broccoli-merge-trees');
var concat = require('broccoli-concat');
var funnel =  require('broccoli-funnel');
var uglify = require('broccoli-uglify-sourcemap');

var tree = "benchmark", uuid;

// Follow the dependency graph and compile into benchmark.js
tree = new ES6Modules(tree, {
  format: 'umd',
  bundleOptions: {
    entry: 'main.js',
    name: 'benchmark-without-deps'
  }
});

// Transpile es6 to es5
tree = esTranspiler(tree);

// Include bower libraries
var uuid = funnel('bower_components/node-uuid', {
  include: ['uuid.js']
});

tree = mergeTrees([tree, uuid]);

// Concatenate files
tree = concat(tree, {
  inputFiles: [
    'uuid.js',
    'benchmark-without-deps.js'
  ],

  outputFile: '/benchmark.js'
});

tree = uglify(tree);

module.exports = tree;
