'use strict';

/* eslint-env node */

/**
 * NOTE: This file is required and executed from the parent directory (so `/`
 * rather than `/chat`). So paths are relative to the parent directory.
 */
const funnel = require('broccoli-funnel');
const mergeTrees = require('broccoli-merge-trees');
const helpers = require('../build-helpers');

let app = funnel('app', {
  srcDir: '/',
  include: [
    // This is required for `ember build` though we don't use it.
    'index.html',

    'app.js',
    'resolver.js',
    'ext/**/*.js',
    'helpers/cast-unobservable-array.js',
    'helpers/format-display-name.js',
    'helpers/i18n-split-string.js',
    'helpers/i18n.js',
    'helpers/at-index.js',
    'helpers/styled-i18n.js',
    'initializers/**/*.js',
    'instance-initializers/**/*.js',
    'utilities/**/*.js',
    'mixins/**/*.js',
    'models/store.js',
    'models/core/paginated-collection.js',
    'models/**/*.js',
    'adapters/*.js',
    'serializers/*.js',

    'controllers/chat.js',
    'controllers/viewers.js',

    'views/chat.js',

    'services/**/*.js',
    'helpers/chat/*.js',
    'helpers/bits-string.js',
    'helpers/filter-emotes.js',
    'helpers/ads-for-bits-enabled.js',
    'helpers/video-sort-label.js',
    'helpers/bits-animated-emote-source.js',
    'helpers/commatized.js',

    'components/loading-spinner.js',
    'components/svg-icon.js',
    'components/chat/**/*',
    'components/emoticon-selector/*',
    'components/follow-button/*',
    'components/twitch-friends-list/twitch-friend-button/*',
    'components/modal-dialog.js',
    'components/bits/**/*',
    'components/tipsy-wrapper.js',
    'components/clips/clips-chat-card/*',
    'components/fallback-image/*',
    'components/progress-bar.js',
    'components/progress-bar/**/*',

    'templates/**/*.hbs'
  ],

  destDir: '/'
});

app = mergeTrees([app, 'chat/app'], { overwrite: true });

app = helpers.buildApp({}, {
  filename: 'emberchat.js',
  onlyFile: true,
  trees: {
    app: app,
    templates: 'app/templates'
  }
});

module.exports = app;
