import Route from 'ember-route';
import $ from 'jquery';
import injectService from 'ember-service/inject';
import { assign } from 'ember-platform';

export default Route.extend({
  session: injectService(),

  init() {
    this._super(...arguments);
    $('.js-ember-loading-screen').hide();
  },

  beforeModel() {
    this._super(...arguments);

    return this.get('session').initializeSession();
  },

  actions: {
    handleNotLoggedIn(options) {
      options = options || {};
      $.login(options);
    },

    openInModal(template, controller, options) {
      return this.render(template, assign({
        into: 'application',
        controller: controller,
        outlet: 'modal'
      }, options));
    },

    closeModal() {
      return this.disconnectOutlet({
        outlet: 'modal',
        parentView: 'application'
      });
    }
  }
});
