import Route from 'ember-route';
import Room from 'web-client/models/room';

export default Route.extend({
  isInteractive(interactiveComponents) {
    return interactiveComponents['chat/chat-room-manager'];
  },

  setupController(controller, model) {
    let currentChannelRoom = Room.findOne(model.channel);
    currentChannelRoom.set('isEmbedChat', true);

    if (!currentChannelRoom.get('isGroupRoom')) {
      controller.setCurrentChannelRoom(model.channel);
      controller.get('currentChannelRoom.channel').load();
    } else {
      controller.set('showList', true);
    }
  }
});
