/*jshint node:true*/

const i18nConfig = require('../i18n/i18n.config.json');

module.exports = function(/* env */) {
  return {
    /**
    * The locales that are application supports.
    *
    * This is optional and is automatically set if project stores translations
    * where ember-intl is able to look them up (<project root>/translations/).
    *
    * If the project relies on side-loading translations, then you must explicitly
    * list out the locales. i.e: ['en-us', 'en-gb', 'fr-fr']
    *
    * NOTE: This is used by loading the locale data
    * 
    * @property locales
    * @type {Array?}
    * @default "null"
    */
    locales: i18nConfig.locales,

    /**
    * baseLocale is used to determine if translation keys are missing from other locales.
    * This property is optional, and if you rely on sideloading translations then
    * this should be null
    *
    * @property baseLocale
    * @type {String?}
    * @default "null"
    */
    baseLocale: i18nConfig.baseLocale,

    /**
    * autoPolyfill, when true will automatically inject the IntlJS polyfill
    * into index.html
    *
    * @property autoPolyfill
    * @type {Boolean}
    * @default "false"
    */
    autoPolyfill: false,

    /**
    * disablePolyfill prevents the polyfill from being bundled in the asset folder of the build
    *
    * NOTE: This is on the CDN and polyfilled by an initializer if the browser needs it
    *
    * @property disablePolyfill
    * @type {Boolean}
    * @default "false"
    */
    disablePolyfill: false,

    /**
    * prevents the translations from being bundled with the application code.
    * This enables asynchronously loading the translations for the active locale
    * by fetching them from the asset folder of the build.
    *
    * See: https://github.com/jasonmit/ember-intl/wiki/Asynchronously-loading-translations
    *
    * NOTE: This addon does not create the translation files, that's created by Ember-Intl-I18n-Twitch
    *
    * @property publicOnly
    * @type {Boolean}
    * @default "false"
    */
    publicOnly: true,


    // NOTE: These has to be a string for Ember-Intl. But Ember-Intl-I18n-Twitch is used for creating translation files
    inputPath: './i18n/doesNotExist',
    outputPath: 'doesNotExist'
  };
};
