/* eslint-env node */

var I18nConfig = require('../i18n/i18n.config.json');

var GIT_COMMIT = process.env.GIT_COMMIT;
if (!GIT_COMMIT) {
  var repoInfo = require('git-repo-info')();
  GIT_COMMIT = repoInfo.sha;
}

module.exports = function (environment) {
  var ENV = {
    modulePrefix: 'web-client',
    environment: environment,
    locationType: 'auto',

    remoteHostports: {
      WWW_HOSTPORT: "",
      CDN_HOSTPORT: "",
      WEBCLIENT_HOSTPORT: "",
      WEBCLIENT_ASSET_NAME: "emberapp.js",
      FEATURES_FILEPATH: "",
      CDN_PATH: "",
      // Only inserted in production by server.go
      META_TAGS: "",
      LOCALE_SHORT: "en",
      LOCALE_LONG: "en-us"
    },

    pubsub: { environment: 'production' },

    rollbar: {
      accessToken: "874b9ba639b44551bedf2751e81935d8",
      captureUncaught: false,
      environment: environment,
      enabled: environment === "production",
      verbose: environment !== "production",
      payload: {
        environment: environment,

        client: {
          javascript: {
            source_map_enabled: true,
            code_version: GIT_COMMIT,
            guess_uncaught_frames: true
          }
        }
      }
    },

    creative: {
      sizmek: {
        oneMin: 60 * 1000,
        fiveMins: 5 * 60 * 1000,
        version1: {
          onLoadPixel: "HTTPS://bs.serving-sys.com/Serving/ActivityServer.bs?cn=as&ActivityID=955036&ns=1",
          oneMinPixel: "HTTPS://bs.serving-sys.com/Serving/ActivityServer.bs?cn=as&ActivityID=955037&ns=1",
          fiveMinPixel: "HTTPS://bs.serving-sys.com/Serving/ActivityServer.bs?cn=as&ActivityID=955038&ns=1"
        },
        version2: {
          onLoadPixel: "HTTPS://bs.serving-sys.com/Serving/ActivityServer.bs?cn=as&ActivityID=956380&ns=1",
          oneMinPixel: "HTTPS://bs.serving-sys.com/Serving/ActivityServer.bs?cn=as&ActivityID=956381&ns=1",
          fiveMinPixel: "HTTPS://bs.serving-sys.com/Serving/ActivityServer.bs?cn=as&ActivityID=956382&ns=1"
        }
      },
      aggregator: {
        host: "https://creative.twitch.tv"
      }
    },

    i18n: {
      baseLocale: I18nConfig.baseLocale,
      intlPolyfillPath: 'https://static-cdn.jtvnw.net/intlpolyfill'
    },

    delay: {
      expiration: 60000,
      search: {
        spinner: 200,
        updateTerm: 1
      },
      whisper: {
        stats: 5000,
        renderStats: 500
      },
      bttv: {
        init: 3000
      },
      channelFeed: {
        twitterPopout: 500
      },
      currentOfferList: {
        pollInterval: 60000
      },
      pinnedCheers: {
        measure: 1000
      },
      premium: {
        flyout: 400,
        getCode: 300
      },
      presence: {
        pollInterval: 60000
      },
      videoUploader: {
        pollStatusInterval: 3000
      },
      dashboard: {
        pollInterval: 30000
      },
      gameSelect: {
        waitForUserTyping: 1000
      }
    },

    algolia: {
      id: "XLUO134HOR",
      key: "d157112f6fc2cab93ce4b01227c80a6d"
    },

    backgroundArtHost: 'https://static-cdn.jtvnw.net/ttv-platforms/background-art',

    EmberENV: {
      EXTEND_PROTOTYPES: {
        Array: true,
        Function: true,
        String: true,
        Date: false
      },

      ENABLE_LOGGING: environment !== "production",
      STUB_OBJECT_CREATE: true,
      FORCE_JQUERY: true,
      GIT_VERSION: GIT_COMMIT,

      FEATURES: {
        // Here you can enable experimental features on an ember canary build
        // e.g. 'with-controller': true
      }
    },

    LANGUAGES: require('./languages.json'),
    APP: {
      // Here you can pass flags/options to your application instance
      // when it is created
    },

    vhsConnections: [
      // HiRez expo: hireztv
      {
        id: 'hirez',
        name: 'Hi-Rez',
        icon: 'https://s.jtvnw.net/jtv_user_pictures/hosted_images/drop-smite-chest',
        message: 'Link your Hi-Rez and Twitch Accounts and watch the SMITE World Championship this weekend for the chance to get Exclusive Skins, Odyssey Chests, and Gems!',
        clientId: 't11hnc4bu1xj2yljd1t4dbruut4srkf',
        connectionUrl: 'https://www.hirezstudios.com/link/',
        startTime: '2017-01-01T00:00:00-05:00',
        endTime: '2017-01-08T23:50:00-05:00',
        channels: [
          'hireztv'
        ]
      },
      // HiRez expo: paladinsgame
      {
        id: 'hirez',
        name: 'Hi-Rez',
        icon: 'https://s.jtvnw.net/jtv_user_pictures/hosted_images/paladins-drop.png',
        message: 'Link your Hi-Rez and Twitch Accounts and watch the Paladins HRX Invitational this weekend for the chance to get the HRX Digital Loot Pack, Radiant Chests, and Crystals!',
        clientId: 't11hnc4bu1xj2yljd1t4dbruut4srkf',
        connectionUrl: 'https://www.hirezstudios.com/link/',
        startTime: '2017-01-01T00:00:00-05:00',
        endTime: '2017-01-08T23:50:00-05:00',
        channels: [
          'paladinsgame'
        ]
      },
      {
        id: 'steam',
        name: 'Steam',
        connectionUrl: 'https://www.twitch.tv/settings/connections',
        channels: []
      }
    ]
  };

  if (process.env.CHAT) {
    ENV.remoteHostports.WEBCLIENT_ASSET_NAME = 'emberchat.js';
  }

  if (environment === 'development') {
    // ENV.APP.LOG_RESOLVER = true;
    // ENV.APP.LOG_ACTIVE_GENERATION = true;
    // ENV.APP.LOG_TRANSITIONS = true;
    // ENV.APP.LOG_TRANSITIONS_INTERNAL = true;
    // ENV.APP.LOG_VIEW_LOOKUPS = true;
    ENV['ember-cli-mirage'] = {
      enabled: false
    };
    ENV['pubsub'] = {
      environment: 'darklaunch'
    };
  }

  if (environment === 'test') {
    // Testem prefers this...
    ENV.baseURL = '/';
    ENV.locationType = 'none';

    // shorten runTask delay (ms) for sizmek food channel pixels in testing environment
    ENV.creative.sizmek.oneMin = 200;
    ENV.creative.sizmek.fiveMin = 1000;

    // keep test console output quieter
    ENV.APP.LOG_ACTIVE_GENERATION = false;
    ENV.APP.LOG_VIEW_LOOKUPS = false;

    // set to true to log all tests starting and stopping
    ENV.APP.LOG_TEST_START_STOP = false;

    ENV.APP.rootElement = '#ember-testing';

    ENV.remoteHostports = {
      WWW_HOSTPORT: "https://www.twitch.tv",
      CDN_HOSTPORT: "//www.twitch.tv",
      WEBCLIENT_HOSTPORT: "",
      FEATURES_FILEPATH: ""
    };

    ENV.delay = {
      expiration: 100,
      search: {
        spinner: 0,
        updateTerm: 0
      },
      whisper: {
        stats: 0,
        renderStats: 0
      },
      bttv: {
        init: 0
      },
      channelFeed: {
        twitterPopout: 0
      },
      currentOfferList: {
        pollInterval: 10
      },
      pinnedCheers: {
        measure: 0
      },
      premium: {
        flyout: 0,
        getCode: 0
      },
      presence: {
        pollInterval: 50
      },
      videoUploader: {
        pollStatusInterval: 1
      },
      dashboard: {
        pollInterval: 0
      },
      gameSelect: {
        waitForUserTyping: 0
      }
    };

    ENV.fastAnimations = true;
  }

  if (environment === 'production' && process.env.CI === 'true') {
    ENV.GOOGLE_SITE_VERIFICATION = 'nfsZd38ZV83T6MdjAsLhwdcQHPT3HkidcTELZkVxE3k';
    ENV.GOOGLE_PUBLISHER_TAG = 'https://plus.google.com/115463106831870703431';

    ENV.remoteHostports = {
      WWW_HOSTPORT: "{{.WWWHostport}}",
      CDN_HOSTPORT: "{{.CDNHostport}}",
      WEBCLIENT_HOSTPORT: "{{.WebClientHostport}}",
      CDN_PATH: "https://web-cdn.ttvnw.net",
      FEATURES_FILEPATH: "https://s3-us-west-2.amazonaws.com/twitch-feature-assets",
      META_TAGS: "{{.MetaTags}}",
      LOCALE_SHORT: "{{.Lang.Short}}",
      LOCALE_LONG: "{{.Lang.Long}}"
    };
  }

  return ENV;
};
