## Addon Migration

Several important parts of web-client functionality are maintained in addons
instead of in the web-client codebase. In spring 2016 we made
[a plan to migrate these addons back into web-client](https://docs.google.com/a/justin.tv/document/d/1fee4w4fzPiDduWlhO9BdgJeLiJWMMRx7y9KB5swTUwE/edit?usp=sharing),
the aim being to improve developer experience across the Twitch web product.

This is a practical guide for merging an addon into web-client, and is largely
based on the experiences of already completed addon migrations.

If you are considering a migration or starting, please reach out to @yaymukund
on Slack and Web Platform will provide a developer to pair on the effort at
least two days a week.

#### Starting the migration

* In #web-client and the chat for the team owning the addon, post a message
  stating your intent to migrate. See if there is a justification for delay.
* Review all open pull requests for an addon. Leave a comment on each stating
  this codebase will be merged into web-client and who is executing the
  migration. This will help developers actively developing for the addon
  to communicate with you.
* Add the description `DEPRECATED - This addon is being migrated to web-client by @myname`
  to the addon github repo.
* Add the same message to the top of the `README.md`. See https://git-aws.internal.justin.tv/web/ember-vod-appeals
  for an example of `OBSOLETE` flagging which is similar.

#### Migrating to web-client

* Do not attempt to refactor or cleanup the code during a merge. Doing so would
  both raise the risk of introducing bugs and make it more difficult for other
  developers to apply their patches to web-client after the merge.
* Port any tests from the addon to the web-client codebase first. They should
  pass with the addon `yarn link`'d to the web-client project.
* As a file is migrated from the addon, delete it from the addon. Eventually
  the addon should have no significant code remaining.
* Open a PR titled `[addon-merge] WIP some-name` on web-client once the
  primary work is complete. Use a todo list to track tasks. Once the tasks are
  complete remove `WIP` from the title and drop the PR into the #ember-crs
  chat on Slack to request feedback. See https://git-aws.internal.justin.tv/web/web-client/pull/499
  for an example of a merge PR
* Run smoca, ensure all Ember tests pass.
* If required, email qa-request@twitch.tv to have a regression check performed
  on the staging server hosting the PR. Specify if all browsers or a single
  browser is required, and if all site functionality or a subset is required.
  The more specific you are, the better the QA team can scope their work
  and get it completed. If you do not hear back from QA within 24 hours of
  sending an email to qa-request@twitch.tv, try to escalate the discussion
  via Slack.

#### Completing the migration

* Merge the PR to web-client
* Close all open PRs on the addon repo.
* Add the description `OBSOLETE, see web-client` to the description of the
  addon repo.
* Add a similar message to the `README.md` with a link to the merge
  PR: `This repo has been made OBSOLETE by migration of the code to web-client in web/web-client#PRNUMBER`
  See https://git-aws.internal.justin.tv/web/ember-vod-appeals for an example.
* Announce the merge in #web-client, #js-infrastructure, and the team's
  chat on Slack. Be sure to link to the merge PR. Congratulations!
* The Web Platform team will include news about the merge in a note to the
  js-guild mailing list and scoop.
