# Importing Modules

**TL;DR** :gift:

Use `import` to import modules from Ember. For example:

```js
import Component from 'ember-component';
export default Component.extend({ ... });

// Don't do this:
import Ember from 'ember';
Ember.Component.extend({ ... });
```

Consult [the `ember-cli-shims` addon](https://github.com/ember-cli/ember-cli-shims/blob/master/README.md) 
for a complete breakdown of how and why we use module imports, as well as a
[list of supported shims](https://github.com/ember-cli/ember-cli-shims/blob/master/app-shims.js).

## Why is this better?

This is useful because it allows the compiler to be smarter 
once we move from the shims to actual modules in Ember. For
example, it enables "tree shaking." Tree shaking is when the
compiler "shakes off" modules that are never imported. By having
many smaller modules, the compiler can say, "Hey, it looks like
`ember-controller` is never `import`ed so I'll just exclude it
from the build." This is great for two reasons:

1. Your built payload is smaller.
2. The omitted modules are *never run*. (For example, if
   `ember-controller` is shaken off, then the `Controller` class
   wouldn't even be declared.)

Ember hasn't yet migrated everything to modules -- that will take
many months of work. In the short term, they've exposed [a set of
shims][ember-cli-shims] that will allow us to use `import`
immediately. When Ember *does* become completely modular, we'll
reap the benefits without changing our code.

[ember-cli-shims]: https://github.com/ember-cli/ember-cli-shims/blob/master/app-shims.js
