/* globals require, module */

var helpers = require('./build-helpers');
var featuresBuilds = require('./config/features');

module.exports = function (defaults) {
  if (helpers.env === 'test') {
    return helpers.buildTestApp(defaults, {app: 'app'}, ['index.html']);
  } else {
    var mergeTrees = require('broccoli-merge-trees');
    var funnel = require('broccoli-funnel');
    var trees = [];

    var indexFeatureFileNames = Object.keys(featuresBuilds).map(function(feature){
      return feature + '.js';
    }).concat('index.html', 'translations/**/*');

    trees.push(
      require('./benchmark/Brocfile'),

      helpers.buildApp(defaults, {
        filename: 'emberapp.js',
        include: indexFeatureFileNames
      }),

      funnel('node_modules/twitch-styles', {
        srcDir: 'static/css',
        destDir: 'styles'
      }),

      require('./global/Brocfile')
    );

    if (helpers.env === 'production' || process.env.TWITCHFULLBUILD) {
      console.log();

      trees.push(
        require('./chat/Brocfile')
      );

    } else {
      console.log();
      console.log('Note: Skipping chat builds. To enable,');
      console.log('use the env flag TWITCHFULLBUILD=1 or --env production.')
    }

    trees = mergeTrees(trees);

    if (helpers.env === 'production') {
      trees = helpers.fingerprintApp(trees);
    }

    return trees;
  }
};
