(function($) {

    $(function() {

        $('.js-set-switch').on('click', function(e) {
            e.preventDefault();

            var $this = $(this),
                id    = $this.data('set-id');
            var method, url;

            if (id === undefined) {
                method = 'DELETE';
                url    = '/settings/turbo/emote_group/' + $this.data('group-name');
            } else {
                method = 'PUT';
                url    = '/settings/turbo/emote_set/' + id;
            }

            $.ajax({
                url: url,
                type: 'POST',
                headers: {
                    'Client-ID': Twitch.api.config.clientID,
                    'X-Http-Method-Override': method,
                    'X-CSRF-Token': $('meta[name="csrf-token"]').attr('content')
                }
            })
            .done(function() {
                $('.js-set-display').hide();
                if (id === undefined) {
                    $('.js-set-display.default').show();
                } else {
                    $(".js-set-display[data-set-id=" + id + ']').show();
                }

                $(".js-set-switch").removeClass("selected");
                $this.addClass("selected");
            });
        });

    });
})(jQuery);
