(function (Twitch) {
  'use strict';

  window.euCookieNotification = function () {
    var isCookieDismissed = Twitch.storage.get('euCookieDismiss');
    if (!isCookieDismissed) {
      Twitch.notify.alert(
        i18n(
          "This site uses cookies. By continuing to browse the site, " +
          "you are agreeing to our use of cookies. Review our " +
          "<a href='/p/cookie-policy'>Cookie Policy</a> for more details."
        ),
        {layout: 'bottomCenter', timeout: false, escape: false},
        function () {
          Twitch.storage.set('euCookieDismiss', 'true');
        }
      );
    }
  };
})(window.Twitch);
