/*
This handles all of the flyout menus for the navigation sidebar on the channel page.
(Account actions, small sidebar search, etc.)

Used instead of popup.js because:
    1. Unused menus aren't sitting around taking up space in the DOM
    2. Flyouts are positioned correctly without doing all kinds of weird css/js things to overwrite popup.js
*/

/*global ich */
(function($) {

    var position = function(ele, anchor) {
        $('#flyout').css({'left' : $('#left_col').outerWidth()});
        $('#flyout .content, #flyout .point').css({
            'top' : 'auto',
            'bottom' : 'auto'
        });

        var pos = ele.offset();

        var wHeight = $(window).height();

        var eTop = pos.top;
        var eHeight = ele.outerHeight();
        var eMid = eTop + (eHeight / 2) - 10;
        var eBot = wHeight - (eTop + eHeight);
        
        var tHeight = $('#flyout .content').outerHeight();

        if (anchor === 'top') {
            $('#flyout .point').css({'top' : eMid - 7});
            if (eTop < 10) {
                $('#flyout .content').css({'top' : 0});
            } else {
                $('#flyout .content').css({'top' : eTop - 10});
            }
        }

        if (anchor === 'mid') {
            $('#flyout .point').css({'top' : eMid - 7});
            $('#flyout .content').css({'top' : eMid - (tHeight / 2)});
        }

        if (anchor === 'bot') {
            $('#flyout .point').css({'bottom' : eBot + (eHeight / 2) - 17});
            if ((eTop + eHeight) > (wHeight - 10)) {
                $('#flyout .content').css({'bottom' : 0});
            } else {
                $('#flyout .content').css({'bottom' : eBot - 10});
            }
        }
    };

    var showFlyout = function(ele, opts) {
        $('.flyout-active')
        .tipsy({trigger: 'hover'})
        .removeClass('flyout-active');

        var node = ich[opts.content](opts.data);

        $('#flyout .content').html(node);
        $('#flyout').show();

        ele
        .addClass('flyout-active')
        .hover(function() {
            $(this).tipsy('hide');
        });
        
        position(ele, opts.anchor);
    };

    var hideFlyout = function() {
        $('.flyout-active')
        .tipsy({trigger: 'hover'})
        .removeClass('flyout-active');

        $('#flyout')
        .hide()
        .children('.content')
        .empty();
    };

    $.fn.flyout = function(target, opts) {
        opts = $.extend({
            'trigger' : false,
            'focusOnLoad' : false,
            'anchor' : 'top',
            'content' : target
        }, opts);

        this.click(function(e) {
            e.preventDefault();
            e.stopPropagation();

            if ($(this).hasClass('flyout-active')) {
                hideFlyout();
            } else {
                showFlyout($(this), opts);

                $(this).tipsy('hide');

                $('#flyout .content').bind('clickoutside', function(e) {
                    if ($('#flyout').is(':visible')) {
                        hideFlyout();
                    }
                });

                if (opts.trigger) {
                    $('body').trigger(opts.trigger);
                }

                if (opts.focusOnLoad) {
                    $(opts.focusOnLoad).focus();
                }
            }
        });
    };

})(jQuery);
