/*global jQuery */
(function($) {

  // We need this in cases where we want to hide a Flash player. jQuery.hide/show destroys
  // the Flash player if hidden and reloads it after showing. Using jQuery.invisible allows us
  // to hide a Flash player from view while still allowing it to run.
  // Also tried using visibility=[visible|hidden] but this failed in IE for our popout handler
  // IE was clearing the ExternalInterface methods on the Flash object when we set visibility=hidden
  // but only during click event handling, not if we set the visibility directly otherwise.
  $.fn.invisible = (function() {
    var actions = {
      show: 100,
      hide: 0
    };

    return function(action) {
      if (actions.hasOwnProperty(action)) {
        var opacity = actions[action];
        return this.each(function() {
          // zoom: 1 is used to force hasLayout in older versions of IE,
          // otherwise the filter property will be ignored
          $(this).css("zoom", "1").css("opacity", Math.floor(opacity / 100))
            .css("filter", "alpha(opacity=" + opacity + ")");
        });
      }
      return this;
    };
  })();

})(jQuery);
