/*global ich, _ */
(function ($) {

  window.initializeLegacyColumns = function (opts) {
    // user menu dropdown
    $('.left-col-dropdown').click(function () {
      if ($(this).hasClass('collapsed')) {
        // get height of hidden menu
        var extraMenuHeight = $('.nav_section .extra-menu')[0].scrollHeight;
        $('.nav_section .extra-menu').animate({ height: extraMenuHeight }, 80);
        $(this).removeClass('collapsed');

      } else {
        $('.nav_section .extra-menu').animate({ height: 0 }, 80);
        $(this).addClass('collapsed');
      }
    });

    $('#footer .show-more-toggle').click(function () {
      if ($(this).hasClass('more')) {
        // show hidden menus
        $('.extra-footer-link').show();
        $(this).removeClass('more');
      } else {
        $('.extra-footer-link').hide();
        $(this).addClass('more');
      }
    });

    opts = opts || {};

    var leftToggle = function () {
      if ($('#left_col').outerWidth() > $('#small_nav .content:first').outerWidth()) {
        Twitch.storage.set('leftColClosed', 'true');
        leftClose();
      } else {
        Twitch.storage.set('leftColClosed', 'false');
        leftOpen();
      }
    };

    var leftClose = function () {
      if ($('#large_nav').is(':visible') && !$('#left_col').hasClass('no-close')) {
        var w = $('#small_nav .content').outerWidth();

        $('#small_nav').show();
        $('#large_nav').hide();
        $('#left_col').css({'width' : w + 'px'});
        $('#main_col').css({'margin-left' : w + 'px'});
        $('#left_close span').css({'background-position' : '0 -18px'});
        $('#left_close').addClass('closed');
        $('#left_col').addClass('closed');

        $(window).trigger('fluid-resize');
      }
    };

    var leftOpen = function () {
      if ($('#small_nav').is(':visible')) {
        var w = $('#large_nav .content').outerWidth();

        $('#small_nav').hide();
        $('#large_nav').show();
        $('#left_col').css({'width' : w + 'px'});
        $('#main_col').css({'margin-left' : w + 'px'});
        $('#left_close span').css({'background-position' : '0 0'});
        $('#left_close').removeClass('closed');
        $('#header_search_small').hide();
        $('#left_col').removeClass('closed');

        $(window).trigger('fluid-resize');
      }
    };

    if (opts.leftAlwaysCollapsed) {
      leftToggle = leftClose;
      leftOpen = leftClose;
      $('#main_col').css({'margin-left' : $('#small_nav .content').outerWidth() + 'px'});
    }

    var rightToggle = function () {
      if ($('#right_col').outerWidth() > 0) {
        Twitch.storage.set('rightColClosed', 'true');
        rightClose();
      } else {
        Twitch.storage.set('rightColClosed', 'false');
        rightOpen();
      }
    };

    var rightClose = function () {
      if ($('#right_col').is(':visible') && !$('#right_col').hasClass('no-close')) {
        $('#right_col').hide();
        $('.advertisement').hide();
        $('#main_col').addClass('expandRight');
        $('#right_col').css({'width' : '0px'});
        $('#right_close').addClass('closed');

        $(window).trigger('fluid-resize');
      }
    };

    var rightOpen = function () {
      if ($('#right_col').is(':hidden')) {
        var w = $('#right_col .content:first').outerWidth();

        $('#right_col').show();
        $('.advertisement').show();
        $('#main_col').removeClass('expandRight');
        $('#right_col').css({'width' : w + 'px'});
        $('#right_close').removeClass('closed');

        $(window).trigger('fluid-resize');
      }
    };

    var setPlaceholder = function () {
      var placeholder = this.getAttribute('data-placeholder');
      if (placeholder && this.src !== placeholder) {
        this.src = placeholder;
      }
    };

    $(window).on('fluid-resize', function () {
      if ($('#right_col')[0]) {
        if ($(window).width() < 800) {
          if (Twitch.storage.get('leftColClosed') !== 'false') { leftClose(); }
          if (Twitch.storage.get('rightColClosed') !== 'false') { rightClose(); }
        } else if ($(window).width() < 1200) {
          if (Twitch.storage.get('leftColClosed') !== 'false') { leftClose(); }
          if (Twitch.storage.get('rightColClosed') !== 'true') { rightOpen(); }
        } else {
          if (Twitch.storage.get('leftColClosed') !== 'true') { leftOpen(); }
          if (Twitch.storage.get('rightColClosed') !== 'true') { rightOpen(); }
        }
      } else {
        if ($(window).width() < 800) {
          if (Twitch.storage.get('leftColClosed') !== 'false') { leftClose(); }
        } else {
          if (Twitch.storage.get('leftColClosed') !== 'true') { leftOpen(); }
        }
      }

      var height = Math.min(
        $('.player_column').width() * 9 / 16 + 32, // 32px is the height of our player controls
          $('.channel-main').height() -
          $('.editable').outerHeight(true) -
          $('#stats_and_actions').outerHeight() +
          1 // #stats_and_actions border size
      );

      $('.live_site_player_container, .archive_site_player_container').css('height', height.toFixed(0) + 'px');
    });

    $(window).resize(_.debounce(function () {
      $(window).trigger('fluid-resize');
    }, 10));

    $('#small_search a').click(function () {
      leftOpen();
      $('#sidebar_search input').focus();
      return false;
    });


    $('#small_more a').flyout('small_more', {'anchor' : 'mid'});
    $('#small_account a').flyout('small_account', {
      anchor: 'bot',
      data: {
        user: Twitch.user.login()
      }
    });

    $('#left_close').click(function (e) {
      e.preventDefault();
      leftToggle();
    });

    $('#right_close').click(function (e) {
      e.preventDefault();
      rightToggle();
    });

    $('.stretch').each(function () {
      var t = 0 + $(this).siblings('.top:first').outerHeight();
      var b = 0 + $(this).siblings('.bottom:first').outerHeight();

      $(this).css({
        'top' :  t + 'px',
        'bottom' : b + 'px',
        'visibility' : 'visible'
      });
    });

    if (Twitch.storage.get('leftColClosed') === 'true') { leftClose(); }
    if (Twitch.storage.get('rightColClosed') === 'true') { rightClose(); }

    $('body')
    .on('rightClose', rightClose)
    .on('rightOpen', rightOpen)
    .on('rightToggle', rightToggle)
    .on('leftClose', leftClose)
    .on('leftOpen', leftOpen)
    .on('leftToggle', leftToggle);

    $('.js-columns-scroll, .js-nav-scroll').TrackpadScrollEmulator({
      wrapContent: false,
      scrollbarHideStrategy: 'rightAndBottom'
    });

    $(window).trigger('fluid-resize');
  };

})(jQuery);
