/*global _, confirm*/
(function ($) {

  var tapstreamUrl = 'http://taps.io/ZMdg?referrer=alert_upsell';

  window.mobileNotification = function () {
    var mobileDevices = [{
      userAgentMatchingPattern: /iPhone|iPod|iPad/i,
      message: i18n("Get the iOS app to watch Twitch anywhere."),
      onconfirm: function () {
        document.location.href = tapstreamUrl;
      }
    },
    {
      userAgentMatchingPattern: /Android|Dalvik|GINGERBREAD/,
      message: i18n("Get the Android app to watch Twitch anywhere."),
      onconfirm: function () {
        document.location.href = tapstreamUrl;
      }
    }];

    mobileDevices.forEach(function (device) {
      if (navigator.userAgent.match(device.userAgentMatchingPattern) &&
          !navigator.userAgent.match(/IEMobile|Windows Phone/) &&
          !Twitch.storage.get("mobile_pushover", { storage: 'sessionStorage' })) {
        Twitch.storage.set("mobile_pushover", "true", { storage: 'sessionStorage' });
        if (confirm(device.message)) {
          device.onconfirm();
        }
      }
    });
  };

})(jQuery);
