/***************************
* Video player functions
****************************/

function archive_play(time) {
  var player = Twitch.player.getPlayer();
  if (player) {
    player.playVideo(time);
  }
}

function live_play() {
  var player = Twitch.player.getPlayer();
  if (player) {
    player.playVideo();
  }
}

function wait_for_live_player_popout_close() {
    if (window.live_popout_window && window.live_popout_window.closed) {
        window.live_popout_window = null;
        $("#popout_message").hide();
        var player = Twitch.player.getPlayer();
        if (player) {
          player.playVideo();
          $(player).invisible('show');
        }
    } else {
        setTimeout(wait_for_live_player_popout_close, 100);
    }
}

function popout_live_player(channel) {
    if (!window.live_popout_window || window.live_popout_window.closed) {
        var window_options = ['right=50',
            'top=50',
            'width=630',
            'height=381',
            'resizable=yes',
            'scrollbars=no',
            'toolbar=no',
            'location=no',
            'directories=no',
            'status=no',
            'menubar=no',
            'copyhistory=no'].join(',');
        window.live_popout_window = window.open('/' + channel + '/popout', '_blank', window_options);
    }
    window.live_popout_window.focus();
    wait_for_live_player_popout_close();
    var player = Twitch.player.getPlayer();
    if (player) {
      $(player).invisible('hide');
      player.pauseVideo();
    }
    $("#popout_message").show();
    return false;
}

function toggle_live_player_popout(channel) {
    if (window.live_popout_window) {
        window.live_popout_window.close();
    } else {
        popout_live_player(channel);
    }
}

window.onbeforeunload = "Twitch.player.getPlayer().pauseVideo();";
window.onunload = "Twitch.player.getPlayer().pauseVideo();";
