/**
 * util.js is on the "JS Hit List", so we should strive to
 * never use functions from it, and remove pieces as time permits.
 */

var BaseDomain = 'justin.tv';

function commatize(n) {
  var reverse = function (str) {
    return str.split("").reverse().join("");
  };
  return reverse(reverse((n + "")).match(/(?:\d*\.)?\d{1,3}-?/g).join(','));
}

function setChannelViewerCount(n, channel) {
  n = n - 0;
  var channelViewerCountEl = jQuery("#channel_viewer_count");
  if (channelViewerCountEl.length) {
    channelViewerCountEl.html(commatize(n));
    if (n > 0) {
      channelViewerCountEl.show();
    } else {
      channelViewerCountEl.hide();
    }
  }

  if (window.PP) {
    PP.channelLive = (n > 0);
    PP.channelViewers = n;
  }
}

var escapeHtml = function (txt, noescape) {
  if (!noescape)
    return txt.replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/\$/g, "&#36;");
  else
    return txt;
};

// for ga tracking everywhere
window._gaq = window._gaq || [];
