/*jshint eqnull:true browser:true */
//
// Twitch dashboard interface
// Depends on twitch.core.js
//
// provides functions for use in the dashboard
// Note that several functions like the rebroadcaster functions should be moved in here
// Usage
// Twitch.dashboard.productModal('/some/url')
//     - Loads the url in a modal window. URL needs to have hold_div as the element where an on_click causes close
//       and main window needs holding_div as per the Twitch Overlay system
(function(Twitch, $) {
    var dashboard = {};

    dashboard.infoModal = function(url, holding_div, closing_div, options) {
        options = typeof options !== 'undefined' ? options : {};
        $(holding_div).overlay(url,function(){
            $(closing_div).click(function(e) {
                e.preventDefault();
                $(this).trigger('overlay.hide');
            });
        },
        Twitch.defaults(options,{'width': '420px'}));
    };

    Twitch.mixin({
        dashboard: dashboard
    });

})(Twitch, jQuery);