/* global CryptoJS */
// = require ./core
// = require ./storage
// = require ./api
// = require ./user
// = require ./uri
// = require ./identifiers
// = require ./experiments
// = require_tree .


(function ($) {
  // jscs:disable requireCamelCaseOrUpperCaseIdentifiers
  var apiUrl = window.location.protocol + '//' + SiteOptions.api_hostport;
  var apiUrlSecure = 'https://' + SiteOptions.api_hostport;
  var streamsApiUrl = window.location.protocol + '//' + SiteOptions.streams_api_hostport;
  var streamsApiUrlSecure = 'https://' + SiteOptions.streams_api_hostport;
  var apiCdnUrl = window.location.protocol + '//' + 'api-akamai.twitch.tv';
  var apiCdnUrlSecure = 'https://' + 'api-akamai.twitch.tv';
  // jscs:enable requireCamelCaseOrUpperCaseIdentifiers

  // Temporary experiment hardcoded here as experiment framework is not yet loaded at this point
  var experimentUUID = '44dbd670-63e6-4f7f-aa47-417f3eccd939';

  var threshold = 0.1;
  var deviceID = Twitch.idsForMixpanel.getOrCreateUniqueId();

  var rng_seed    = experimentUUID + deviceID;
  var hashed_seed = CryptoJS.SHA1(rng_seed);
  var rand_int   = hashed_seed.words[0] >>> 0;
  var rand_float = rand_int / Math.pow(2, 32);

  var useApiCdn = (rand_float < threshold) && (SiteOptions.deploy_flavor === 'production'); // Roll out to 10% of users

  Twitch.api.init({
    baseUrl: useApiCdn ? apiCdnUrl : apiUrl,
    baseUrlSecure: useApiCdn ? apiCdnUrlSecure : apiUrlSecure,
    streamsBaseUrl: useApiCdn ? apiCdnUrl : streamsApiUrl,
    streamsBaseUrlSecure: useApiCdn ? apiCdnUrlSecure : streamsApiUrlSecure,
    receiverUrl: (useApiCdn ? apiCdnUrl : apiUrl) + '/crossdomain/receiver.html?v=2',
    login: Twitch.user.login()
  });
})(jQuery);
