/*jshint browser:true */
//
// Twitch bootloader for page-specific javascript
// Load assets based on the action, stored in a data-
// attribute on <body>
// Technique from Paul Irish
// http://viget.com/inspire/extending-paul-irishs-comprehensive-dom-ready-execution
// https://gist.github.com/46Bit/3606848

(function(Twitch, jQuery) {

  var actions = [];

  var action = function(page, callback) {
    this._actions[page] = this._actions[page] || [];
    this._actions[page].push(callback);
    return this;
  };

  var run = function(page) {
    if (this._actions[page]) {
      for (var i = 0, len = this._actions[page].length; i < len; i++) {
        // Pass in a clean reference to jQuery so actions can
        // use $ without a closure
        this._actions[page][i](jQuery);
      }
    }
    return this;
  };

  Twitch.mixin({
    _actions: actions,
    action: action,
    run: run
  });

})(Twitch, jQuery);
