/* jshint eqnull:true, browser:true */
/* global noty */

//
// Twitch notification interface
// Depends on twitch.core.js, twitch.display.js, libs/jquery.noty.js
//
// Use this to display notifications to users!
// Usage: Twitch.notify
//   Twitch.notify(message, [callback]) - alias to alert
//   Twitch.notify.success(message, [callback])
//   Twitch.notify.error(message, [callback])
//   Twitch.notify.alert(message, [callback])
//
//   If defined, callback is called when the notification is
//   closed (automatically or by the user)
//
// The underlying implementation uses noty (http://needim.github.com/noty)
// but that usually shouldn't matter to you. You can queue multiple events
// and the stack will be handled correctly.

(function(Twitch, $) {
  var defaultOpts = {
    layout: 'top',
    template: '<div class="noty_message"><div class="text-container"><div class="glitch"></div><div class="noty_text"></div></div><div class="noty_close"><svg class="svg-close_small" height="16px" version="1.1" viewbox="0 0 16 16" width="16px" x="0px" y="0px"><path clip-rule="evenodd" d="M12.657,4.757L9.414,8l3.243,3.242l-1.415,1.415L8,9.414l-3.243,3.243l-1.414-1.415L6.586,8L3.343,4.757l1.414-1.414L8,6.586l3.242-3.243L12.657,4.757z" fill-rule="evenodd"></path></svg></div></div>',
    dismissQueue: true,
    animation: {
      open: { height: 'toggle' },
      close: { height: 'toggle' },
      easing: 'linear',
      speed: 200
    },
    timeout: 4000,
    closeWith: ['button']
  };

  var notify = function(message, options, callback) {
    notify.alert.apply(notify, arguments);
  };

  notify._dispatch = function(type, message, options, callback) {
    options = options || {};
    if (typeof(options) === 'function') {
      callback = options;
      options = {};
    }

    var merged = Twitch.defaults({
      type: type,
      text: message,
      callback: {
        onClose: callback || false
      }
    }, options, defaultOpts);

    if (merged.escape) {
      merged.text = Twitch.display.escape(message);
    }

    return noty(merged);
  };

  notify.alert = function(message, options, callback) {
    return notify._dispatch('alert', message, options, callback);
  };

  notify.notice = function(message, options, callback) {
    return notify._dispatch('notice', message, options, callback);
  };

  notify.success = function(message, options, callback) {
    return notify._dispatch('success', message, options, callback);
  };

  notify.error = function(message, options, callback) {
    return notify._dispatch('error', message, options, callback);
  };

  notify.flash = function(options, callback) {
    var $notifications = $('#header_notification'),
      $error         = $notifications.find('.flash-error'),
      $success       = $notifications.find('.flash-success'),
      $notice        = $notifications.find('.flash-notice');


    if ($error.length) {
      return notify.error($error.text(), options, callback);
    }

    if ($success.length) {
      return notify.success($success.text(), options, callback);
    }

    if ($notice.length) {
      return notify.alert($notice.text(), options, callback);
    }
  };

  Twitch.mixin({
    notify: notify
  });

})(Twitch, jQuery);
