//= require ./flash_player
//= require ./flash_player_2

(function (Twitch, $) {
  var AdFeedbackMenu = function (el, player) {
    var self = this,
        lastAdId = null;

    self.player = player;
    self.$playerEl = player.$el;
    player.on('adFeedbackShow', function (o) {
      lastAdId = o.adId;
      self.show();
    });

    self.$el = $(el);
    self.$el.find('.close-btn').click(function () {
      self.$el.hide();
    });

    self.$el.find('a').each(function (index, el) {
      var $a = $(el);
      $a.click(function (e) {
        e.preventDefault();
        self.$el.hide();
        player.adFeedbackDone({ad_id: lastAdId, ad_feedback: $a.attr('name')});
      });
    });
  };

  $.extend(AdFeedbackMenu.prototype, {
    show: function () {
      this.$el.show();
    }
  });

  Twitch.player.AdFeedbackMenu = AdFeedbackMenu;
})(Twitch, jQuery);
