/*jshint browser:true, bitwise:false */
/*global EventHandler,ContextLoader,console */

//= require rsvp
//= require underscore

//= require ./index.js
//= require ./event_handler
//= require ./context_loader

(function (Twitch, $) {

  var EventController = function (channel, streamUrl, additionalProperties) {
    this.context = new Twitch.player.ContextLoader(channel, streamUrl);
    this.handler = new Twitch.player.EventHandler(this.context, additionalProperties);
    this.trackingMinutesWatched = false;
  };

  EventController.prototype.trackVideoPlaying = function (playerController) {
    if (!this.trackingMinutesWatched) {
      var counter = 1,
          self = this;
      this.trackingMinutesWatched = true;
      this.sendVideoPlay();
      setInterval(function () {
        if (!playerController.contentPlayer.paused) {
          console.info("logging a minute watched " + new Date().toTimeString());
          self.sendMinuteWatched(counter++);
        }
      }, 60 * 1000);
    }
  };

  EventController.prototype.sendMinuteWatched = function (minutesLogged) {
    this.handler.handle("minute-watched", {
      "minutes_logged" : minutesLogged,
      // minute watched needs a new distinct id ever call because of mp sampling
      "distinct_id" : Twitch.idsForMixpanel.createUniqueId()
    });
  };

  EventController.prototype.sendVideoPlay = function () {
    this.handler.handle("video-play");
  };

  EventController.prototype.sendVideoAdOpportunity = function (rollType, provider) {
    this.handler.handle("video_ad_opportunity", {
      "provider" : provider,
      "roll_type" : rollType
    });
  };

  EventController.prototype.sendVideoAdImpression = function (rollType, provider) {
    this.handler.handle("video_ad_impression", {
      "provider" : provider,
      "roll_type" : rollType
    });
  };

  Twitch.player.EventController = EventController;

})(Twitch, jQuery);
