/* global console, swfobject */

//= require ./index

(function (Twitch, $) {

  var SWF_EVENTS = ['streamLoaded', 'videoLoaded', 'online', 'offline', 'adCompanionRendered', 'viewerCount',
    'videoLoading', 'videoPlaying', 'tosViolation', 'popout', 'loginRequest', 'adFeedbackShow', 'mouseScroll'];

  var FlashPlayer = function (options) {
    this.options = options;
    FlashPlayer.instantiationCounter++;
  };
  FlashPlayer.instantiationCounter = 0;
  $.extend(FlashPlayer.prototype, {
    _proxy: function () {
      var self = this;
      $.each([
        'fullscreen',
        'getVideoTime',
        'loadStream',
        'loadVideo',
        'mute',
        'isPaused',
        'pauseVideo',
        'playVideo',
        'setOauthToken',
        'onlineStatus',
        'unmute',
        'videoSeek',
        'adFeedbackDone'
      ],
        function (index, value) {
          self[value] = self.el[value].bind(self.el);
        });
    },
    init: function (success, error) {
      console.info('FlashPlayer.init');

      this._initSuccess = success || function () {};
      error = error || function () {};

      var self = this,
          o = this.options;
      o.flashVars.eventsCallback = swfCallbacks.register(function (events) {
        self._onEvents(events);
      });
      swfobject.embedSWF(o.url,
                         o.swfId,
                         o.width,
                         o.height,
                         o.version,
                         "/widgets/expressinstall.swf",
                         o.flashVars,
                         o.params,
                         o.attrs,
                         function (e) {
                           if (e.success) {
                             self.$el = $('#' + self.options.swfId);
                             self.el = self.$el[0];
                           } else {
                             console.info('FlashPlayer.init error');
                             error('error embedding flash player');
                           }
                         });
    },
    _onPlayerInit: function () {
      this._proxy();
      this.adFeedbackMenu = new Twitch.player.AdFeedbackMenu($('.js-ad-feedback-menu').first(), this);
      console.info('FlashPlayer.init success');
      this._initSuccess(this);
    },
    destroy: function () {
    },
    _onEvents: function (events) {
      var event;
      for (var i = 0; i < events.length; i++) {
        event = events[i];
        try {
          this._onEvent(event);
        } catch (err) {
          console.warn("Error handling FlashPlayer event " + event.event + ": " + err);
        }
      }
    },
    _onEvent: function (event) {
      switch (event.event) {
      case "playerInit":
        this._onPlayerInit();
        break;
      default:
        this.trigger(event.event, event.data);
        break;
      }
    }
  });

  RSVP.EventTarget.mixin(FlashPlayer.prototype);

  var swfCallbacks = {
    callbackId: 0,
    register: function (callback) {
      Twitch.player.FlashPlayer.callbacks = Twitch.player.FlashPlayer.callbacks || {};
      var id = 'callback' + this.callbackId++;
      Twitch.player.FlashPlayer.callbacks[id] = callback;
      return 'Twitch.player.FlashPlayer.callbacks.' + id;
    }
  };

  Twitch.player.FlashPlayer = FlashPlayer;

})(Twitch, jQuery);
