/* jshint browser:true */
/* global window, Twitch, jQuery */

// Our Client ID
// jscs:disable requireCamelCaseOrUpperCaseIdentifiers
window.sp_cid = "qFEaZsFQnwEdUIs";
// jscs:enable requireCamelCaseOrUpperCaseIdentifiers

(function (Twitch, $) {
  var SCRIPT_URL = "//d2lv4zbk7v5f93.cloudfront.net/esf.js";

  var sentinelPromise = new RSVP.Promise(function (resolve, reject) {
    $.ajax({
      url: SCRIPT_URL,
      dataType: 'script',
      timeout: 2000,
      cache: true
    }).fail(function (xhr, settings, exception) {
      reject();
    });

    document.addEventListener('sp.blocking', function () {
      resolve(true);
    });

    document.addEventListener('sp.not_blocking', function () {
      resolve(false);
    });
  });

  var sentinel = {
    detect: sentinelPromise,
    pageTransition: function () {
      if (window._sp_ && window._sp_.pageChange) {
        window._sp_.pageChange();
      }
    }
  };

  Twitch.mixin({
    sentinel: sentinel
  });

})(Twitch, jQuery);
