/*global Spinner */
// Forked from https://gist.github.com/1290439
// You can now create a spinner using any of the variants below:
//
//  - $("#el").spin(); // Produces default Spinner using the text color of #el
//  - $("#el").spin({ ... }); // Produces a Spinner using your custom settings.
//  - $("#el").spin(false); // Kills the spinner.

(function($) {
    $.fn.spin = function(options, color) {
        var defaultOptions = {
            lines: 12, // The number of lines to draw
            length: 2, // The length of each line
            width: 4, // The line thickness
            radius: 10, // The radius of the inner circle
            color: '#3D6B99', // #rgb or #rrggbb
            speed: 1.4, // Rounds per second
            trail: 70, // Afterglow percentage
            shadow: false // Whether to render a shadow
        };

        if (Spinner) {
            return this.each(function() {
                var $this = $(this),
                    data = $this.data();

                if (data.spinner) {
                    data.spinner.stop();
                    delete data.spinner;
                }

                if (options !== false) {
                    var mergedOptions = Twitch.defaults({
                        color: color || (options && options.color) || $this.css('color')
                    }, options, defaultOptions);

                    data.spinner = new Spinner(mergedOptions).spin(this);
                }
            });
        } else {
            throw new Error("Spinner class not available.");
        }
    };
})(jQuery);
