package twitchhttp_test

import (
	"log"
	"net/http"

	"code.justin.tv/common/twitchhttp"
	"goji.io"
	"goji.io/pat"
	"golang.org/x/net/context"
)

type MyServer struct {
	*goji.Mux
}

func Example_server() {
	server := twitchhttp.NewServer()

	s := &MyServer{server}
	s.HandleFuncC(pat.Get("/foo"), s.endpoint)

	log.Fatal(twitchhttp.ListenAndServe(s))
}

func (s *MyServer) endpoint(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	w.Write([]byte("OK"))
}
