job {
  name 'vidhurv-web-client'
  label 'jenkins-prod-web-client-slave-0'
  using 'TEMPLATE-autobuild'

  wrappers {
    sshAgent 'git-aws-read-key'
		preBuildCleanup()
		timestamps()
    credentialsBinding {
      string('GITHUB_ACCESS_TOKEN', 'devtools-deployment-github-api-token')
      file('COURIERD_PRIVATE_KEY', 'courierd')
			file('AWS_CONFIG_FILE', 'aws_config')
		}
    logRotator {
        daysToKeep(14)
    }
    environmentVariables {
      env('AUTO_DEPLOY_ENV', 'clean-production')
    }
    timeout {
      noActivity(300)
      failBuild()
      writeDescription('Build failed due to timeout after {0} minutes :notlikethis:')
    }
  }

  scm {
    git {
      remote {
        github 'vidhurv/web-client', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  steps {
    shell 'rm -rf .manta/'
    shell '[ "$GIT_BRANCH" = "origin/master" ]; IS_MASTER_BUILD =$?'
    shell 'manta -v -proxy -E IS_MASTER_BUILD=$IS_MASTER_BUILD'
    saveDeployArtifact 'vidhurv/web-client', '.manta/dist'
  }

  publishers {
    // from https://git-aws.internal.justin.tv/release/jenkins-jobs/blob/3018d18f578c13d02985ea507d709f07efd48b73/templates/autobuild.groovy#L18-L20
    githubCommitNotifier()

    //*********** Test Results ******************
    archiveJunit('.manta/test-results/*.xml') {
      allowEmptyResults()
      retainLongStdout()
    }

    //*********** Code Coverage ******************
    cobertura('.manta/coverage/cobertura-coverage.xml') {
      failNoReports(false)
      sourceEncoding('ASCII')
      onlyStable(true)
    }

    publishHtml {
      report('.manta/coverage') {
        allowMissing(true)
        keepAll(true)
        reportName('Code Coverage Output')
      }
    }


    //*********** AUTO-DEPLOY ******************
    postBuildScripts {
      steps {
        conditionalSteps {
          runner('DontRun')

          // when running against a master build only, automatically deploy once the build succeeds
          condition {
            and {
              stringsMatch('$GIT_BRANCH', 'origin/master', false)
            } {
              status('UNSTABLE', 'SUCCESS')
            }
          }

          steps {
            shell "./scripts/auto-deploy.sh"
          }
        }
      }
    }
  }
}

job {
  name 'vidhurv-web-client-deploy'
  using 'TEMPLATE-deploy'

  logRotator {
    daysToKeep(14)
  }
  parameters {
    booleanParam('TRIGGER_SMOCA', false)
    stringParam('GITHUB_CREATOR', '')
  }

  steps {
    shell 'courier deploy --repo vidhurv/web-client --dir /opt/twitch/twitch-client'

    // Run Smoca downstream if TRIGGER_SMOCA is true
    conditionalSteps {
      condition {
        booleanCondition('$TRIGGER_SMOCA')
      }
      runner('Fail')
      steps {
        downstreamParameterized {
          trigger('qa-smoca', 'ALWAYS') {
            parameters {
              currentBuild()
            }
          }
        }
      }
    }
  }
}

job {
  name 'vidhurv-web-client-deploy-production'
  using 'TEMPLATE-deploy'
  steps {
    downloadDeployArtifact 'vidhurv/web-client'
    shell """curl https://api.rollbar.com/api/1/sourcemap \
        -F access_token=7d3317786bfd441ca58ee6fa9bb69fff \
        -F version=\$GIT_COMMIT \
        -F minified_url=http://web-cdn.ttvnw.net/emberapp.js \
        -F source_map=@./emberapp.map"""
    shell 'courier deploy --repo vidhurv/web-client --dir /opt/twitch/twitch-client'
  }
}
