import apiRoutes from 'web-client/mirage/routes/api';
import badgesRoutes from 'web-client/mirage/routes/badges';
import bitsRoutes from 'web-client/mirage/routes/bits';
import clipsRoutes from 'web-client/mirage/routes/clips';
import commerceRoutes from 'web-client/mirage/routes/commerce';
import apiKrakenRoutes from 'web-client/mirage/routes/api-kraken';
import clientEventReporterRoutes from 'web-client/mirage/routes/client-event-reporter';
import commerceAmendments from 'web-client/mirage/routes/commerce-amendments';
import connectionsRoutes from './routes/connections';
import emailVerificationRoutes from './routes/email-verification';
import extensionsRoutes from './routes/extensions';
import imRoutes from 'web-client/mirage/routes/im';
import friendsRoutes from 'web-client/mirage/routes/friends';
import onsiteNotificationRoutes from 'web-client/mirage/routes/onsite-notifications';
import playlistRoutes from 'web-client/mirage/routes/playlists';
import presenceRoutes from 'web-client/mirage/routes/presence';
import spadeRoutes from 'web-client/mirage/routes/spade';
import streamKrakenRoutes from 'web-client/mirage/routes/stream-kraken';
import subscriptionsRoutes from 'web-client/mirage/routes/subscriptions';
import videoRoutes from 'web-client/mirage/routes/video';
import videoStatsRoutes from 'web-client/mirage/routes/video-stats';
import vodUploadRoutes from 'web-client/mirage/routes/video-uploads';
import { presenceHost } from 'web-client/utilities/presence-util';
import timezones from 'web-client/mirage/fixtures/timezones';
import userRoutes from 'web-client/mirage/routes/users';
import eventRoutes from 'web-client/mirage/routes/events';

export default function() {

  // These comments are here to help you get started. Feel free to delete them.

  /*
    Config (with defaults).

    Note: these only affect routes defined *after* them!
  */

  // this.urlPrefix = '';    // make this `http://localhost:8080`, for example, if your API is on a different server
  // this.namespace = '';    // make this `api`, for example, if your API is namespaced
  // this.timing = 400;      // delay for each request, automatically set to 0 during testing

  /*
    Shorthand cheatsheet:

    this.get('/posts');
    this.post('/posts');
    this.get('/posts/:id');
    this.put('/posts/:id'); // or this.patch
    this.del('/posts/:id');
  */

}

export function testConfig() {
  // Set to true to enable Mirage request/response logging
  this.logging = false;

  this.passthrough('/write-coverage');

  /*
   * Stubbed routes are grouped by namespace in separate files.
   * The namespaces passed here are the same as the function defaults.
   * Explicitly passing them here so that it is visible in one place where to
   * change them if needed. For example, you may want to route all these
   * requests to your local dev or a staging server.
   */
  apiRoutes(this, 'http://api.twitch.tv/api');
  badgesRoutes(this, 'https://badges.twitch.tv/v1/badges');
  bitsRoutes(this, 'http://api.twitch.tv/bits');
  clipsRoutes(this);
  apiKrakenRoutes(this, 'http://api.twitch.tv/kraken');
  clientEventReporterRoutes(
    this,
    'https://client-event-reporter.twitch.tv/v1',
    'https://client-event-reporter-darklaunch.twitch.tv/v1'
  );
  commerceAmendments(this, 'http://api.twitch.tv/v5');
  connectionsRoutes(this, 'http://api.twitch.tv/v5');
  emailVerificationRoutes(this);
  extensionsRoutes(this);
  imRoutes(this, 'http://im.twitch.tv/v1');
  onsiteNotificationRoutes(this);
  playlistRoutes(this);
  presenceRoutes(this, `${presenceHost}/v1`);
  presenceRoutes(this, `${presenceHost}/v2`);
  spadeRoutes(this, 'http://spade.twitch.tv');
  streamKrakenRoutes(this, 'http://api.twitch.tv/kraken');
  subscriptionsRoutes(this);
  videoRoutes(this);
  videoStatsRoutes(this);
  vodUploadRoutes(this);
  friendsRoutes(this, 'http://api.twitch.tv/v4');
  userRoutes(this);
  commerceRoutes(this, 'http://api.twitch.tv/v5');
  eventRoutes(this, 'http://api.twitch.tv/v5');

  /*
   * Do not permit tracking requests to go through to
   * mixpanel.
   */
  this.get('http://api.mixpanel.com/**', function() { return 0; }, 200);
  this.post('http://api.mixpanel.com/**', function() { return 0; }, 200);

  /*
   * Return success for all pubster initialization (?) requests
   */
  this.post('https://pubster.twitch.tv/publish', function() { return ''; }, 200);

  this.get('http://minixperiment.twitch.tv/experiments.json', function() {
    return {
      "0b13a04c-883c-4b35-97d1-5055eb8f34c5":{name:"ios_preroll_test",groups:[{weight:92,value:"control"},{weight:5,value:"cellular_test"},{weight:3,value:"all_test"}]},"143da2f9-bf80-4555-a661-76c378fcd5c8":{name:"ios_aa",groups:[{weight:0,value:"control"},{weight:1,value:"variant"}]},"424531b4-e23d-47d2-87c7-9b90a23ddd06":{name:"ABS V1",groups:[{weight:5,value:"yes"},{weight:95,value:"no"}]},"4e61c5c6-8cfb-485e-87f1-fc21c0d03068":{name:"Preroll Ads",groups:[{weight:99,value:"yes"},{weight:1,value:"no"}]},"5fbb67a0-b4ff-4775-b836-e9a348a87481":{name:"Network Profile Collection",groups:[{weight:999,value:"no"},{weight:1,value:"yes"}]},"61b169ff-bc62-4725-a40e-1be627197c6f":{name:"Recommended Games",groups:[{weight:75,value:"no"},{weight:25,value:"yes"}]},"6e398bad-ccb3-4e38-8370-a521f093a30e":{name:"Resume VOD",groups:[{weight:0,value:"control"},{weight:100,value:"resume"}]},"906c9e2f-ac8a-43f3-9f7f-78668e292d4f":{name:"android_aa",groups:[{weight:50,value:"control"},{weight:50,value:"variant"}]},"9dd1a159-7aa3-43c1-a504-af97ae44120c":{name:"HTTPS_REDIRECT",groups:[{weight:100,value:"ignore"},{weight:0,value:"ssl"},{weight:0,value:"nossl"}]},"aaac75ea-c969-4826-b32d-ceefac620a79":{name:"Recommended Channels",groups:[{weight:0,value:"no"},{weight:100,value:"yes"}]},"afa3914d-3596-49da-92af-555e97c24171":{name:"VOD Marker Availability",groups:[{weight:1,value:"yes"},{weight:0,value:"no"}]},"b1f39341-e4ba-455c-b361-a31927f4bf2c":{name:"player cloudfront",groups:[{weight:0,value:"yes"},{weight:100,value:"no"}]},"c05d8638-eb34-4929-a565-670e733b5079":{name:"android_subs_experiment",groups:[{weight:20,value:"control"},{weight:80,value:"android_subs"}]}};
  }, 200);

  this.get('http://tmi.twitch.tv/hosts', function() {
    return {hosts:[{host_id:45982670,host_login:"riotgameseu"}]};
  }, 200);

  this.get('http://tmi.twitch.tv/api/rooms/:id/recent_messages', function() {
    return {messages:[]};
  }, 200);

  this.get('http://chatdepot.twitch.tv/room_memberships', function() {
    return { memberships: [] };
  });

  this.get('https://vod-secure.twitch.tv/timezones.json', function() {
    return timezones;
  });

  this.post('/:channel/dashboard/delay', function() {
    return;
  }, 200);

  this.get('https://creative.twitch.tv/**',
    function() { return { game: 'Creative', aggregate: {communities:[], streams:[]}};
  }, 200);

  /*
   * Passthroughs
   */
  this.passthrough('http://player.twitch.tv/html/player.411a35df.html');
}
