import { Factory } from 'ember-cli-mirage';

/**
 * A list of badges that can be used in the channel's chat.
 *
 * A response to:
 *   `GET /chat/:channel/badges`
 *
 * Example request:
 *   ```
 *     curl -H 'Accept: application/vnd.twitchtv.v3+json' \
 *     -X GET https://api.twitch.tv/kraken/chat/test_user1/badges
 *   ```
 *
 * See https://github.com/justintv/Twitch-API/blob/master/v3_resources/chat.md#get-chatchannelbadges
 */
export default Factory.extend({
  name: 'twitch', // used to generate '_links', not actually returned by the API

  "global_mod": {
    "alpha":"https://chat-badges.s3.amazonaws.com/globalmod-alpha.png",
    "image":"https://chat-badges.s3.amazonaws.com/globalmod.png",
    "svg":"https://chat-badges.s3.amazonaws.com/globalmod.svg"
  },
  "admin":{
    "alpha":"https://chat-badges.s3.amazonaws.com/admin-alpha.png",
    "image":"https://chat-badges.s3.amazonaws.com/admin.png",
    "svg":"https://chat-badges.s3.amazonaws.com/admin.svg"
  },
  "broadcaster": {
    "alpha":"https://chat-badges.s3.amazonaws.com/broadcaster-alpha.png",
    "image":"https://chat-badges.s3.amazonaws.com/broadcaster.png",
    "svg":"https://chat-badges.s3.amazonaws.com/broadcaster.svg"
  },
  "mod":{
    "alpha":"https://chat-badges.s3.amazonaws.com/mod-alpha.png",
    "image":"https://chat-badges.s3.amazonaws.com/mod.png",
    "svg":"https://chat-badges.s3.amazonaws.com/mod.svg"
  },
  "staff":{
    "alpha":"https://chat-badges.s3.amazonaws.com/staff-alpha.png",
    "image":"https://chat-badges.s3.amazonaws.com/staff.png",
    "svg":"https://chat-badges.s3.amazonaws.com/staff.svg"
  },
  "turbo":{
    "alpha":"https://chat-badges.s3.amazonaws.com/turbo-alpha.png",
    "image":"https://chat-badges.s3.amazonaws.com/turbo.png",
    "svg":"https://chat-badges.s3.amazonaws.com/turbo.svg"
  },
  _links() {
    return {
      "self":`http://api.twitch.tv/kraken/chat/${this.name}/badges`
    };
  }
});
