import { Factory } from 'ember-cli-mirage';

/**
 * An apparently undocumented API request for chat properties
 * for the given channel, in response to:
 *   `GET /channels/:channel/chat_properties`
 *
 * TODO find out if/where API docs for this endpoint exist.
 */
export default Factory.extend({
  _id(i) {
    return i;
  },
  "hide_chat_links": true,
  "devchat": false,
  "game": "Gaming Talk Shows",
  "require_verified_account": true,
  "subsonly": false,
  "eventchat": false,
  "cluster": "aws",
  "chat_servers": [
    "irc.chat.twitch.tv:80",
    "irc.chat.twitch.tv:6667",
    "irc.chat.twitch.tv:6667",
    "irc.chat.twitch.tv:80"
  ],
  "web_socket_servers": [
    "irc-ws.chat.twitch.tv:80",
    "irc-ws.chat.twitch.tv:80",
    "irc-ws.chat.twitch.tv:80"
  ],
  "web_socket_pct": 1.0,
  "darklaunch_pct": 1.0,
  "block_chat_notification_token": null,
  "available_chat_notification_tokens": [
    {
      "token_id": 9000,
      "token_message": "It's your 9 Month Anniversary!",
      "token_month": "9",
      "token_kind": "subscription"
    }
  ]
});
