import { Factory } from 'ember-cli-mirage';
import { JTV_USER_PICTURES_URL } from 'web-client/utilities/urls/static-cdn';

/**
 * An apparently undocumented API request for channel data specific to ember
 * for the given channel, in response to:
 *   `GET /channels/:channel/ember`
 *
 * TODO find out if/where API docs for this endpoint exist.
 */
export default Factory.extend({
  _id(i) {
    return i;
  },
  name: 'twitch',
  display_name() {
    return this.name;
  },
  mature: false,
  status: 'Sponsored by MTV: The Shannara Chronicles Premiere + Q&A with Author Terry Brooks',
  broadcaster_language: 'en',
  game: 'Gaming Talk Shows',
  delay: 0,
  delay_controls_enabled: true,
  partner: true,
  created_at: '2007-05-22T10:39:54Z',
  updated_at: '2016-02-24T22:46:02Z',
  teespring_campaign_enabled: false,
  logo: `${JTV_USER_PICTURES_URL}/twitch-profile_image-42277a83919bd975-300x300.png`,
  video_banner: `${JTV_USER_PICTURES_URL}/twitch-channel_offline_image-2b1f0f6c9efa13bf-640x360.png`,
  profile_banner: `${JTV_USER_PICTURES_URL}/twitch-profile_banner-6936c61353e4aeed-480.png`,
  channel_feed_enabled: true,
  primary_team_name: 'staff',
  primary_team_display_name: 'Staff Display',
  url() {
    return `https://www.twitch.tv/${this.name}`;
  },
  views: 72528222,
  followers: 422119,
  prerolls: true,
  show_chat: true,
  creative: {
    commission_button: false
  }
});
