import { Factory } from 'ember-cli-mirage';

/**
 * A response to:
 *   `GET /streams/:channel`
 *
 * Example request:
 *   ```
 *     curl -H 'Accept: application/vnd.twitchtv.v3+json' \
 *     -X GET https://api.twitch.tv/kraken/streams/test_channel
 *   ```
 * See https://github.com/justintv/Twitch-API/blob/master/v3_resources/streams.md#get-streamschannel
 */

export default Factory.extend({
  name: 'twitch', // not present in real api response but used to generate other
                  // properties below
  _id(i) {
    return i;
  },
  stream: null,
  _links() {
    return {
      "self":`https://api.twitch.tv/kraken/streams/${this.name}`,
      "channel":`https://api.twitch.tv/kraken/channels/${this.name}`
    };
  }
});
