import { Factory } from 'ember-cli-mirage';
import { JTV_USER_PICTURES_URL } from 'web-client/utilities/urls/static-cdn';

/**
 * A response to:
 *   `GET /channels/:channel/`
 *
 * This json payload may also be embedded as the `stream` property in
 * response to:
 *   `GET /streams/:channel/`
 *
 * or as an item in the `streams` array property in response to:
 *   `GET /streams`
 */
export default Factory.extend({
  _id(i) {
    return i;
  },

  name: 'twitch',
  mature: false,
  status: "Sponsored by MTV: The Shannara Chronicles Premiere + Q\u0026A with Author Terry Brooks",
  broadcaster_language: "en",
  game: "Gaming Talk Shows",
  language: "en",
  created_at: "2007-05-22T10:39:54Z",
  updated_at: "2016-02-24T22:46:02Z",
  logo: `${JTV_USER_PICTURES_URL}/twitch-profile_image-42277a83919bd975-300x300.png`,
  video_banner: `${JTV_USER_PICTURES_URL}/twitch-channel_offline_image-2b1f0f6c9efa13bf-1920x1080.png`,
  profile_banner: `${JTV_USER_PICTURES_URL}/twitch-profile_banner-6936c61353e4aeed-480.png`,
  partner: true,
  views: 72528222,
  followers: 422124,
  channel_feed_enabled: true,

  display_name() {
    return this.name;
  },

  url() {
    return `https://www.twitch.tv/${this.name}`;
  },

  _links() {
    return {
      "self": `http://api.twitch.tv/kraken/channels/${this.name}`,
      "follows": `http://api.twitch.tv/kraken/channels/${this.name}/follows`,
      "commercial": `http://api.twitch.tv/kraken/channels/${this.name}/commercial`,
      "stream_key": `http://api.twitch.tv/kraken/channels/${this.name}/stream_key`,
      "chat": `http://api.twitch.tv/kraken/chat/${this.name}`,
      "features": `http://api.twitch.tv/kraken/channels/${this.name}/features`,
      "subscriptions": `http://api.twitch.tv/kraken/channels/${this.name}/subscriptions`,
      "editors": `http://api.twitch.tv/kraken/channels/${this.name}/editors`,
      "teams": `http://api.twitch.tv/kraken/channels/${this.name}/teams`,
      "videos": `http://api.twitch.tv/kraken/channels/${this.name}/videos`
    };
  }
});
