import { Factory, trait, faker } from 'ember-cli-mirage';

const CLIPS_URL = 'https://clips.twitch.tv';
const TWITCH_URL = 'https://www.twitch.tv';
const CLIPS_ASSETS_URL = 'https://clips-media-assets.twitch.tv';

export default Factory.extend({
  id(i) {
    return `slug${i}`;
  },
  url() {
    return `${CLIPS_URL}/${this.id}`;
  },

  broadcaster: {
    id: faker.random.number(),
    login: 'somebroadcaster',
    display_name() { return this.broadcaster.login; },
    channel_url() { return `${TWITCH_URL}/${this.broadcaster.login}`; }
  },

  curator: {
    id: faker.random.number(),
    login: 'somecurator',
    display_name() { return this.curator.login; },
    channel_url() { return `${TWITCH_URL}/${this.curator.login}`; }
  },

  createdAt: faker.date.recent(),
  game: faker.list.random('Overwatch', 'Dota 2', 'Hearthstone'),
  title: faker.lorem.words(),
  views: faker.random.number(),

  thumbnail() {
    let fakeBroadcastID = faker.random.number();
    let fakeOffset = faker.random.number();
    let baseThumbnailURL = `${CLIPS_ASSETS_URL}/${fakeBroadcastID}-offset-${fakeOffset}`;

    return {
      medium: `${baseThumbnailURL}-480x272.jpg`,
      small: `${baseThumbnailURL}-260x147.jpg`,
      tiny: `${baseThumbnailURL}-86x45.jpg`
    };
  },

  legacyURL: trait({
    id(i) {
      return `${this.broadcasterLogin}/slug${i}`;
    }
  })
});
