import { Factory, faker } from 'ember-cli-mirage';

export default Factory.extend({
  name() {
    return `My ${faker.commerce.productName()} Extension`;
  },
  author: faker.internet.userName,
  companyId: faker.internet.userName,
  description: faker.lorem.lines,
  summary: faker.lorem.text,
  supportEmail: faker.internet.exampleEmail,
  iconUrl: faker.image.avatar,
  aboutUrl: faker.internet.url,
  viewerUrl: faker.internet.url,
  configUrl: faker.internet.url,
  version: '1.0',

  screenshotUrls() {
    let numImages = faker.random.arrayElement([3, 4, 5]);
    let images = [];
    for (let i = 0; i < numImages; i++) {
      images.push(faker.image.imageUrl(320, 480, 'abstract'));
    }

    return images;
  }
});
