import { Factory } from 'ember-cli-mirage';
import getServer from '../get-server';

export default Factory.extend({
  name(i) {
    return `featured-game-${i}`;
  },

  game(i) {
    return getServer().create('game', {
      name: `featured-game-${i}`,
      _is_featured: true
    });
  },

  featuredOnSidePanel: true,
  featuredOnDirectory: true,
  featuredOnFrontPage: true,
  trackingUrls(i) {
    return {
      clickthroughUrl: `clickthroughurl-${i}`,
      trackingPixelUrl: `trackingpixelurl-${i}`
    };
  }
});
