import { Factory } from 'ember-cli-mirage';
import getServer from '../get-server';

/**
 * A response to:
 *   `GET /streams/featured`
 *
 * Example request:
 *   ```
 *     curl -H 'Accept: application/vnd.twitchtv.v3+json' \
 *     -X GET https://api.twitch.tv/kraken/streams/featured
 *   ```
 *
 * See https://github.com/justintv/Twitch-API/blob/master/v3_resources/streams.md#get-streamsfeatured
 */
export default Factory.extend({
  // name isn't present in real API response, but used to generate other
  // properties below.
  name(i) {
    return `fake_user_${i}`;
  },

  "image": "http://s.jtvnw.net/jtv_user_pictures/hosted_images/TwitchPartnerSpotlight.png",
  "text": "<p>some html to describe this featured stream</p>",
  "title": "Twitch Partner Spotlight",
  "sponsored": false,
  "scheduled": true,

  priority(i) {
    return i;
  },

  stream() {
    return getServer().create('stream', { name: this.name, is_featured: true });
  }
});
