import { Factory, trait, faker } from 'ember-cli-mirage';

export default Factory.extend({
  action_details(i) {
    return {
      destination_url: `https://twitch.amazon.com/checkout/summary?asin=ASIN${i}`
    };
  },
  product(i) {
    let gameName = `Game ${i}`;
    let gameAsin = `ASIN${i}`;
    return {
      asin: gameAsin,
      description: `Details for game ${gameName}`,
      developer_name: faker.company.companyName(),
      edition: 'Standard',
      external_destination_url: '',
      eula_url: 'https://twitch.tv/',
      feature_details: [
        faker.lorem.sentence(),
        faker.lorem.sentence()
      ],
      feature_icons: [],
      game_id: gameName.toLowerCase(),
      game_embargo_date: '2036-09-30T00:00:00Z',
      genres: [],
      is_externally_entitled: false,
      maturity_ratings: {
        esrb: {
          details: [],
          icon_url: 'https://static-cdn.jtvnw.net/details/esrb/rating_pending',
          rating: 'Rating Pending'
        },
        pegi: {
          details: [],
          icon_url: 'https://static-cdn.jtvnw.net/details/pegi/ages_12_and_over',
          rating: 'PEGI 12'
        }
      },
      media: {
        background_image_url: 'https://images-na.ssl-images-amazon.com/images/I/A1s5Dn4PbcL.jpg',
        box_art_url: 'https://images-na.ssl-images-amazon.com/images/I/61242jdqe0L.png',
        screenshot_urls: [
          'https://images-na.ssl-images-amazon.com/images/I/A15t1eN9L5L.jpg',
          'https://images-na.ssl-images-amazon.com/images/I/A1+q5s77ZEL.jpg'
        ],
        videos: [
          {
            video_id: 'v91545192',
            thumbnail_url: 'https://images-na.ssl-images-amazon.com/images/G/01/twitch/thumbnails/Streamline_Trailer_1.jpg'
          }
        ]
      },
      release_end_date: '2036-09-30T00:00:00Z',
      price: {
        currency_unit: 'USD',
        price: '19.99'
      },
      publisher_name: faker.company.companyName(),
      supported_platforms: [
        {
          icon_url: 'https://static-cdn.jtvnw.net/details/platform/pc',
          platform: 'Pc'
        }
      ],
      support_url: 'https://twitch.tv/',
      system_requirements: {
        minimum: {
          direct_x_version: 'DirectX 11',
          hard_drive_space: '4GB',
          os_version: [
            'Windows 7/8/10 (64-bit OS required)'
          ],
          other: 'Twitch ID and internet connection required',
          processor: [
            'Intel Core i5-2410M 2.3GHz or equivalent'
          ],
          ram: '4GB',
          video_card: [
            'Intel HD Graphics 3000 or equivalent'
          ]
        },
        recommended: {
          direct_x_version: 'DirectX 11',
          hard_drive_space: '6GB',
          os_version: [
            'Windows 7/8/10 (64-bit OS required)'
          ],
          other: 'Twitch ID and internet connection required',
          processor: [
            '3 GHz processor'
          ],
          ram: '8GB',
          video_card: [
            'Nvidia GeForce 8800/AMD Radeon HD 5670 or equivalent video card (Dedicated GPU with 512MB+ Video Memory(VRAM))'
          ]
        }
      },
      title: gameName,
      website_url: 'http://twitch.tv/'

    };
  },
  user_entitlement: {
    'entitled': false
  },
  entitled: trait({
    user_entitlement:{
      entitled: true
    }
  }),
  notForSale: trait({
    product: {
      release_end_date: '2006-09-30T00:00:00Z'
    }
  })

});
